<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEducationBackgroundTable extends Migration
{
    public function up()
    {
        Schema::create('education_background', function (Blueprint $table) {
            $table->id('Education_id'); // Primary key, auto-incrementing
            $table->unsignedBigInteger('User_id')->nullable(); // Foreign key, nullable
            $table->string('Institution', 255);
            $table->string('Degree', 255);
            $table->string('Field_of_study', 255);
            $table->date('Start_date');
            $table->date('End_date')->nullable();
            $table->boolean('Currently_studying')->default(false);
            $table->text('Description')->nullable();
            $table->timestamps();

            // Define foreign key constraint
            $table->foreign('User_id')->references('User_id')->on('users')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('education_background');
    }
}
